<?php
use \HubPublic\Http\CurlRequest;

class GambioHubAccountPasswordContentControl extends GambioHubAccountPasswordContentControl_parent
{
    public function proceed()
    {
        parent::proceed();
        $this->updateCustomerEncryptionKey();
    }

    public function updateCustomerEncryptionKey()
    {
        try {
            if(sizeof($this->error_array) == 0) {
                if (isset($this->data_array['password_new']) && isset($this->data_array['password_current'])) {
                    $email = $this->get_current_email();
                    $newPass = $this->data_array['password_new'];
                    $oldPass = $this->data_array['password_current'];
                    $keyGenerator = MainFactory::create('HubKeyGenerator');
                    $oldKey = $keyGenerator->generateCustomerEncryptionKey($email, $oldPass);
                    $newKey = $keyGenerator->generateCustomerEncryptionKey($email, $newPass);
                    $this->executeReEncryptCustomerVault($oldKey, $newKey);
                    $_SESSION['customer_encryption_key'] = $newKey;
                }
            }
            return;
        } catch (Exception $exception) {
            return;
        }
    }

    /**
     * Send request to Hub to re-encrypt vault
     * 
     * @param $oldKey
     * @param $newKey
     * @return void
     */
    private function executeReEncryptCustomerVault($oldKey, $newKey)
    {
        $hubSettings = MainFactory::create('HubSettings', gm_get_conf('GAMBIO_HUB_CURL_TIMEOUT'));
        $hubCallbackApiClient = MainFactory::create(
            'HubCallbackApiClient',
            MODULE_PAYMENT_GAMBIO_HUB_URL,
            new CurlRequest(),
            LogControl::get_instance(),
            $hubSettings
        );
        $query = [
            'client_key' => gm_get_conf('GAMBIO_HUB_CLIENT_KEY'),
            'customer_id' => $_SESSION['customer_id'],
            'old_key' => $oldKey,
            'new_key' => $newKey,
        ];
        $hubCallbackApiClient->execute(
            'PayPal2Hub',
            true,
            [
                'source' => 're_encrypt_vault'
            ],
            $query
        );
    }

}
